/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.FTBEssentialsPlatform;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.DurationUtil;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.OtherPlayerInventory;
import dev.ftb.mods.ftblibrary.util.PlayerDisplayNameUtil;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;

public class CheatCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (FTBEConfig.HEAL.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"heal").requires(FTBEConfig.HEAL.enabledAndOp())).executes(context -> CheatCommands.heal(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.heal(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.FLY.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fly").requires(FTBEConfig.FLY.enabledAndOp())).executes(context -> CheatCommands.fly(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.fly(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.GOD.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"god").requires(FTBEConfig.GOD.enabledAndOp())).executes(context -> CheatCommands.god(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.god(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.INVSEE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"invsee").requires(FTBEConfig.INVSEE.enabledAndOp())).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.invsee(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.NICK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nicknamefor").requires(FTBEConfig.NICK.enabledAndOp())).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(context -> CheatCommands.nicknamefor((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ""))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).requires(source -> source.m_6761_(2))).executes(context -> CheatCommands.nicknamefor((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"nickname"))))));
        }
        if (FTBEConfig.MUTE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mute").requires(FTBEConfig.MUTE.enabledAndOp())).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.mute((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ""))).then(Commands.m_82129_((String)"until", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CheatCommands.suggestTimeouts(builder)).executes(context -> CheatCommands.mute((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"until"))))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"unmute").requires(FTBEConfig.MUTE.enabledAndOp())).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.unmute((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
    }

    public static int heal(ServerPlayer player) {
        player.m_21153_(player.m_21233_());
        player.m_36324_().m_38707_(40, 40.0f);
        player.m_20095_();
        FTBEssentialsPlatform.curePotionEffects(player);
        return 1;
    }

    public static int fly(ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        if (data == null) {
            return 0;
        }
        Abilities abilities = player.m_150110_();
        if (data.fly) {
            data.fly = false;
            data.markDirty();
            abilities.f_35936_ = false;
            abilities.f_35935_ = false;
            player.m_5661_((Component)Component.m_237113_((String)"Flight disabled"), true);
        } else {
            data.fly = true;
            data.markDirty();
            abilities.f_35936_ = true;
            player.m_5661_((Component)Component.m_237113_((String)"Flight enabled"), true);
        }
        player.m_6885_();
        return 1;
    }

    public static int god(ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        if (data == null) {
            return 0;
        }
        Abilities abilities = player.m_150110_();
        if (data.god) {
            data.god = false;
            data.markDirty();
            abilities.f_35934_ = false;
            player.m_5661_((Component)Component.m_237113_((String)"God mode disabled"), true);
        } else {
            data.god = true;
            data.markDirty();
            abilities.f_35934_ = true;
            player.m_5661_((Component)Component.m_237113_((String)"God mode enabled"), true);
        }
        player.m_6885_();
        return 1;
    }

    public static int invsee(ServerPlayer source, final ServerPlayer player) {
        source.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return player.m_5446_();
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player p) {
                return new ChestMenu(MenuType.f_39961_, id, playerInventory, (Container)new OtherPlayerInventory(player), 5);
            }
        });
        return 1;
    }

    public static int nicknamefor(CommandSourceStack source, ServerPlayer player, String nick) {
        if (nick.length() > 30) {
            player.m_5661_((Component)Component.m_237113_((String)"Nickname too long!"), false);
            return 0;
        }
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        if (data == null) {
            return 0;
        }
        data.nick = nick.trim();
        data.markDirty();
        PlayerDisplayNameUtil.refreshDisplayName((Player)player);
        if (data.nick.isEmpty()) {
            source.m_81354_((Component)Component.m_237113_((String)"Nickname reset!"), true);
        } else {
            source.m_81354_((Component)Component.m_237113_((String)("Nickname changed to '" + data.nick + "'")), true);
        }
        data.sendTabName(source.m_81377_());
        return 1;
    }

    public static int mute(CommandSourceStack source, ServerPlayer player, String duration) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        if (data == null) {
            return 0;
        }
        DurationUtil.DurationInfo info = DurationUtil.calculateUntil(duration);
        if (info == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Invalid duration syntax: '" + duration + "'")));
            source.m_81352_((Component)Component.m_237113_((String)"Use a number followed by 'm' (minutes), 'h' (hours), 'd' (days) or 'w' (weeks)"));
            return 0;
        }
        data.muted = true;
        FTBEWorldData.instance.setMuteTimeout(player, info.until());
        data.markDirty();
        MutableComponent msg = player.m_5446_().m_6881_().m_130946_(" has been muted by ").m_7220_(source.m_81357_()).m_130946_(", ").m_130946_(info.desc());
        CheatCommands.notifyMuting(source, (Player)player, (Component)msg);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestTimeouts(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(Stream.of("5m", "10m", "1h", "1d", "1w", "<number>[smhdw]"), (SuggestionsBuilder)builder);
    }

    public static int unmute(CommandSourceStack source, ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        if (data == null) {
            return 0;
        }
        data.muted = false;
        FTBEWorldData.instance.setMuteTimeout(player, -1L);
        data.markDirty();
        MutableComponent msg = player.m_5446_().m_6881_().m_130946_(" has been unmuted by ").m_7220_(source.m_81357_());
        CheatCommands.notifyMuting(source, (Player)player, (Component)msg);
        return 1;
    }

    private static void notifyMuting(CommandSourceStack source, Player target, Component msg) {
        source.m_81377_().m_6846_().m_11314_().forEach(p -> {
            if (p.m_20310_(2) || p == target) {
                p.m_5661_(msg, false);
            }
        });
        if (!source.m_230897_()) {
            source.m_81354_(msg, true);
        }
    }
}

